<?php
session_start();
date_default_timezone_set('Asia/Kolkata'); // Added timezone fix

require_once 'config.php';

if (isset($_POST['user'])) {
    if ($_POST['user'] == ADMIN_USER && $_POST['pass'] == ADMIN_PASS) {
        $_SESSION['admin_logged_in'] = true;
        header('Location: index.php');
        exit;
    } else {
        $error = "❌ Invalid username or password!";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Login - Money King Bot</title>
<style>
/* your CSS remains unchanged */
body {
  margin: 0;
  padding: 0;
  font-family: 'Poppins', sans-serif;
  background: linear-gradient(135deg, #7F00FF, #E100FF);
  height: 100vh;
  display: flex;
  align-items: center;
  justify-content: center;
  overflow: hidden;
}
.card {
  background: rgba(255,255,255,0.15);
  box-shadow: 0 8px 32px 0 rgba(31,38,135,0.37);
  backdrop-filter: blur(10px);
  -webkit-backdrop-filter: blur(10px);
  border-radius: 20px;
  border: 1px solid rgba(255,255,255,0.18);
  padding: 30px;
  width: 90%;
  max-width: 380px;
  animation: fadeIn 0.8s ease-out;
}
@keyframes fadeIn {
  from {opacity: 0; transform: translateY(20px);}
  to {opacity: 1; transform: translateY(0);}
}
h1 {
  color: #fff;
  font-size: 26px;
  font-weight: 700;
  text-align: center;
  margin-bottom: 10px;
}
p.subtitle {
  color: rgba(255,255,255,0.8);
  text-align: center;
  font-size: 14px;
  margin-bottom: 25px;
}
input {
  width: 100%;
  padding: 12px;
  margin-bottom: 15px;
  border-radius: 10px;
  border: none;
  outline: none;
  font-size: 14px;
  background: rgba(255,255,255,0.2);
  color: #fff;
}
input::placeholder { color: rgba(255,255,255,0.7); }
button {
  width: 100%;
  padding: 12px;
  border-radius: 10px;
  border: none;
  background: linear-gradient(90deg, #8E2DE2, #4A00E0);
  color: #fff;
  font-weight: 600;
  cursor: pointer;
  transition: all 0.3s ease;
}
button:hover {
  transform: scale(1.05);
  background: linear-gradient(90deg, #4A00E0, #8E2DE2);
}
.error {
  background: rgba(255,0,0,0.2);
  color: #ffbaba;
  text-align: center;
  padding: 8px;
  border-radius: 8px;
  margin-bottom: 10px;
  font-size: 14px;
}
.footer {
  text-align: center;
  color: rgba(255,255,255,0.8);
  font-size: 12px;
  margin-top: 15px;
}
.footer span {
  font-weight: bold;
  color: #fff;
}
</style>
</head>
<body>
  <div class="card">
    <h1>Admin Panel</h1>
    <p class="subtitle">Login to manage your Telegram Gift Bot</p>

    <?php if (isset($error)): ?>
      <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST">
      <input type="text" name="user" placeholder="👤 Username" required>
      <input type="password" name="pass" placeholder="🔑 Password" required>
      <button type="submit">Login</button>
    </form>

    <div class="footer">© <?= date('Y') ?> Developer: <span>Tajeem</span></div>
  </div>
</body>
</html>
