<?php
session_start();
if(!isset($_SESSION['admin_logged_in'])){ header('Location: login.php'); exit; }

require_once 'db.php';
require_once 'config.php';
include 'header.php';

$cfg_file = __DIR__.'/settings.json';
$settings = ['reward_join'=>45,'reward_referral'=>15,'min_withdraw'=>150];
if(file_exists($cfg_file)){
    $tmp = json_decode(file_get_contents($cfg_file), true);
    if(is_array($tmp)) $settings = array_merge($settings, $tmp);
}

$msg = '';
if(isset($_POST['save'])){
    $settings['reward_join'] = (int)$_POST['reward_join'];
    $settings['reward_referral'] = (int)$_POST['reward_referral'];
    $settings['min_withdraw'] = (int)$_POST['min_withdraw'];
    file_put_contents($cfg_file, json_encode($settings, JSON_PRETTY_PRINT));
    $msg = "Settings saved. Bot will use new values immediately.";
}

?>

<div class="container mx-auto p-4">
  <h1 class="text-2xl font-bold mb-4">Settings</h1>

  <?php if($msg): ?><div class="mb-4 p-3 rounded bg-green-100 text-green-800"><?=htmlspecialchars($msg)?></div><?php endif; ?>

  <form method="POST" class="bg-white p-4 rounded shadow grid gap-3 w-full sm:w-1/2">
    <label>Reward per channel join (₹)</label>
    <input name="reward_join" type="number" class="border p-2 rounded" value="<?=htmlspecialchars($settings['reward_join'])?>" required>

    <label>Reward per referral (₹)</label>
    <input name="reward_referral" type="number" class="border p-2 rounded" value="<?=htmlspecialchars($settings['reward_referral'])?>" required>

    <label>Minimum withdrawal (₹)</label>
    <input name="min_withdraw" type="number" class="border p-2 rounded" value="<?=htmlspecialchars($settings['min_withdraw'])?>" required>

    <div>
      <button name="save" class="bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded">Save Settings</button>
    </div>
  </form>
</div>

<?php include 'footer.php'; ?>
