<?php
// db.php — database connection helper
require_once __DIR__.'/config.php';

function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        $dsn = 'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4';
        try {
            $pdo = new PDO($dsn, DB_USER, DB_PASS, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            ]);
        } catch (Exception $e) {
            http_response_code(500);
            echo 'Database connection failed: ' . $e->getMessage();
            exit;
        }
    }
    return $pdo;
}

// Helper to fetch single user by telegram_id
function getUser($telegram_id) {
    $pdo = getDB();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE telegram_id=?");
    $stmt->execute([$telegram_id]);
    return $stmt->fetch();
}

// Helper to update user balance
function updateBalance($telegram_id, $amount) {
    $pdo = getDB();
    $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE telegram_id=?");
    $stmt->execute([$amount, $telegram_id]);
}

// Helper to record referral bonus
function creditReferral($referrer_id) {
    $pdo = getDB();
    $stmt = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id=?");
    $stmt->execute([REWARD_PER_REFERRAL, $referrer_id]);
}
?>
