<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// =============== CONFIG ===============
$botToken    = "8017774373:AAHsrMEzFLFY_1ENNGO-chFaAiQ1xJjKI6c"; // TEST TOKEN
$botUserName = "Free_deposit_hunter98_bot"; // @ ke bina

$apiURL   = "https://api.telegram.org/bot" . $botToken;

// DB credentials
$dbHost = "localhost";
$dbUser = "site5572_Bot111";
$dbPass = "site5572_Bot111";
$dbName = "site5572_Bot111";

// 10 CHANNELS (id + link)
$channels = [
    // 1
    [
        "id"   => -1003485013744,
        "link" => "https://t.me/+5QdILm-R15dlMTFl"
    ],
    // 2
    [
        "id"   => -1002366835689,
        "link" => "https://t.me/+PpHTNT5LcRRiY2U1"
    ],
    // 3
    [
        "id"   => -1002938898450,
        "link" => "https://t.me/+4MuRS7T4sGQwNGE9"
    ],
    // 4
    [
        "id"   => -1003341360800,
        "link" => "https://t.me/+ny2wMXOdLiw3Yjk1"
    ],
    // 5
    [
        "id"   => -1002277981527,
        "link" => "https://t.me/+WqfQul0cjn0yZjA1"
    ],
    // 6
    [
        "id"   => -1003474748962,
        "link" => "https://t.me/+EOec6PM9NeAwZGY1"
    ],
    // 7
    [
        "id"   => -1003494937344,
        "link" => "https://t.me/+jwEYO3FL9xFiYTll"
    ],
    // 8
    [
        "id"   => -1003474083782,
        "link" => "https://t.me/+nMNpnDLPxgFjZDU1"
    ],
    // 9
    [
        "id"   => -1003426096610,
        "link" => "https://t.me/+y5qV9p7SsnoyMzg1"
    ],
    // 10
    [
        "id"   => -1003073117909,
        "link" => "https://t.me/+BmjCknvVjudiM2Nl"
    ],
];

$min_withdraw      = 150;  // UPI withdrawal minimum
$join_bonus        = 10;   // verify + bonus button = 10 rs
$referral_bonus    = 20;   // per referral 20 rs
$min_deposit_game  = 110;  // 91 Club / OK Win min deposit
// ======================================

// ---------- DB CONNECT ----------
$mysqli = new mysqli($dbHost, $dbUser, $dbPass, $dbName);
if ($mysqli->connect_errno) {
    error_log("DB Connection Failed: " . $mysqli->connect_error);
    exit;
}
$mysqli->set_charset("utf8mb4");

// ---------- HELPER: sendMessage ----------
function sendMessage($chatId, $text, $replyMarkup = null)
{
    global $apiURL;

    $params = [
        "chat_id" => $chatId,
        "text"    => $text,
        "parse_mode" => "HTML"
    ];

    if ($replyMarkup) {
        $params["reply_markup"] = json_encode($replyMarkup);
    }

    file_get_contents($apiURL . "/sendMessage?" . http_build_query($params));
}

// ---------- HELPER: answerCallback ----------
function answerCallback($callbackId, $text = "")
{
    global $apiURL;

    $params = [
        "callback_query_id" => $callbackId
    ];

    if (!empty($text)) {
        $params["text"] = $text;
        $params["show_alert"] = false;
    }

    file_get_contents($apiURL . "/answerCallbackQuery?" . http_build_query($params));
}

// ---------- HELPER: getChatMember ----------
function getChatMemberStatus($chatId, $userId)
{
    global $apiURL;

    $url = $apiURL . "/getChatMember?chat_id=" . urlencode($chatId) . "&user_id=" . $userId;
    $response = file_get_contents($url);
    if (!$response) {
        return null;
    }
    $data = json_decode($response, true);
    if (!isset($data['ok']) || !$data['ok']) {
        return null;
    }
    return $data['result']['status'];
}

// ---------- HELPER: UPI FORMAT CHECK ----------
function isValidUpi($upi)
{
    // simple format: word/.-_ + @ + bank
    return (bool)preg_match('/^[a-zA-Z0-9.\-_]{2,}@[a-zA-Z]{2,}$/', $upi);
}

// ---------- TRANSACTION LOG ----------
function addTransaction($telegram_id, $type, $amount, $details = null)
{
    global $mysqli;
    $telegram_id = (string)$telegram_id;
    $safe_tid = $mysqli->real_escape_string($telegram_id);

    $q = $mysqli->query("SELECT id FROM users WHERE telegram_id = '$safe_tid' LIMIT 1");
    if (!$q || $q->num_rows == 0) {
        return;
    }
    $row = $q->fetch_assoc();
    $uid = intval($row['id']);

    $stype   = $mysqli->real_escape_string($type);
    $samount = floatval($amount);
    $sdet    = $details ? ("'" . $mysqli->real_escape_string($details) . "'") : "NULL";

    $mysqli->query("INSERT INTO transactions (user_id, type, amount, details)
                    VALUES ($uid, '$stype', $samount, $sdet)");
}

// ---------- USER FUNCTIONS ----------
function getOrCreateUser($telegram_id, $first_name = "", $username = "", $referral_from = null)
{
    global $mysqli, $referral_bonus;

    $telegram_id = (string)$telegram_id;
    $safe_tid = $mysqli->real_escape_string($telegram_id);

    $q = $mysqli->query("SELECT * FROM users WHERE telegram_id = '$safe_tid' LIMIT 1");
    if ($q && $q->num_rows > 0) {
        return $q->fetch_assoc();
    }

    $sfname = $mysqli->real_escape_string($first_name);
    $suser  = $mysqli->real_escape_string($username);

    $ref_by = "NULL";
    if (!empty($referral_from) && $referral_from !== $telegram_id) {
        $ref_by = "'" . $mysqli->real_escape_string($referral_from) . "'";
    }

    // New user insert
    $mysqli->query("INSERT INTO users (telegram_id, first_name, username, referred_by) 
                    VALUES ('$safe_tid', '$sfname', '$suser', $ref_by)");

    // Referral bonus (only once on new user)
    if ($ref_by !== "NULL") {
        $ref_tid = $mysqli->real_escape_string($referral_from);
        $mysqli->query("UPDATE users 
                        SET balance = balance + $referral_bonus,
                            total_ref_earnings = total_ref_earnings + $referral_bonus
                        WHERE telegram_id = '$ref_tid'");

        // Transaction entry
        addTransaction($referral_from, 'referral', $referral_bonus, "Referral bonus from user $telegram_id");

        // REFERRAL NOTIFICATION
        $ref_name = !empty($first_name) ? $first_name : "New User";
        $msg  = "👥 <b>New Referral Received!</b>\n\n";
        $msg .= "User: <b>" . htmlspecialchars($ref_name) . "</b>\n";
        $msg .= "ID: <code>$telegram_id</code>\n";
        $msg .= "Aapke account me ₹$referral_bonus referral bonus add ho gaya hai. 🎉";
        sendMessage($referral_from, $msg);
    }

    $q2 = $mysqli->query("SELECT * FROM users WHERE telegram_id = '$safe_tid' LIMIT 1");
    return $q2 ? $q2->fetch_assoc() : null;
}

function updateUserBalance($telegram_id, $amount_change)
{
    global $mysqli;
    $telegram_id = (string)$telegram_id;
    $safe_tid = $mysqli->real_escape_string($telegram_id);
    $amount = floatval($amount_change);
    $mysqli->query("UPDATE users SET balance = balance + $amount WHERE telegram_id = '$safe_tid'");
}

function setUserStep($telegram_id, $step = null, $tempData = null)
{
    global $mysqli;
    $telegram_id = (string)$telegram_id;
    $safe_tid = $mysqli->real_escape_string($telegram_id);
    $step_sql = $step ? ("'" . $mysqli->real_escape_string($step) . "'") : "NULL";
    $temp_sql = $tempData ? ("'" . $mysqli->real_escape_string($tempData) . "'") : "NULL";

    $mysqli->query("UPDATE users SET step = $step_sql, temp_data = $temp_sql WHERE telegram_id = '$safe_tid'");
}

function getUserByTelegram($telegram_id)
{
    global $mysqli;
    $telegram_id = (string)$telegram_id;
    $safe_tid = $mysqli->real_escape_string($telegram_id);
    $q = $mysqli->query("SELECT * FROM users WHERE telegram_id = '$safe_tid' LIMIT 1");
    if ($q && $q->num_rows > 0) {
        return $q->fetch_assoc();
    }
    return null;
}

// ---------- NEW: REFERRAL COUNT ----------
function getReferralCount($telegram_id)
{
    global $mysqli;
    $telegram_id = (string)$telegram_id;
    $safe_tid = $mysqli->real_escape_string($telegram_id);

    $q = $mysqli->query("SELECT COUNT(*) AS c FROM users WHERE referred_by = '$safe_tid'");
    if ($q && $row = $q->fetch_assoc()) {
        return intval($row['c']);
    }
    return 0;
}

// ---------- CHECK CHANNELS 1–5 ----------
function verifyFirstFiveChannels($userId)
{
    global $channels;
    $okStatuses = ["creator", "administrator", "member"];

    for ($i = 0; $i < 5; $i++) {
        $ch = $channels[$i];
        $status = getChatMemberStatus($ch['id'], $userId);
        if (!$status || !in_array($status, $okStatuses)) {
            return false;
        }
    }
    return true;
}

// ---------- CHECK CHANNELS 6–10 ----------
function verifyLastFiveChannels($userId)
{
    global $channels;
    $okStatuses = ["creator", "administrator", "member"];

    for ($i = 5; $i < 10; $i++) {
        $ch = $channels[$i];
        $status = getChatMemberStatus($ch['id'], $userId);
        if (!$status || !in_array($status, $okStatuses)) {
            return false;
        }
    }
    return true;
}

// ---------- MAIN MENU ----------
function sendMainMenu($chatId, $user = null)
{
    $keyboard = [
        "keyboard" => [
            [
                ["text" => "💰 Balance"],
                ["text" => "👥 Referral"]
            ],
            [
                ["text" => "🏧 UPI Withdrawal"]
            ],
            [
                ["text" => "🎮 91 Club Deposit"],
                ["text" => "🎮 OK Win Deposit"]
            ]
        ],
        "resize_keyboard" => true
    ];

    $text = "📲 <b>Main Menu</b>\n";
    $text .= "Option select karo niche se:";

    sendMessage($chatId, $text, $keyboard);
}

// ---------- START: CHANNEL 1–5 MESSAGE ----------
function sendJoinChannelsMessageStart($chatId)
{
    global $channels;

    $text  = "👋 <b>Welcome!</b>\n\n";
    $text .= "Bot use karne ke liye pehle ye <b>1 se 5</b> channel JOIN karo.\n";
    $text .= "Niche diye gaye <b>Join</b> buttons se join karo,\n";
    $text .= "phir <b>✅ Verify Channels</b> button dabao.\n";

    // 1–5 channels, 2-column layout
    $inline = [];
    $row = [];
    for ($i = 0; $i < 5; $i++) {
        $ch = $channels[$i];
        $row[] = [
            "text" => "Join",
            "url"  => $ch['link']
        ];
        if (count($row) == 2) {
            $inline[] = $row;
            $row = [];
        }
    }
    if (!empty($row)) {
        $inline[] = $row;
    }

    // verify button
    $inline[] = [
        [
            "text" => "✅ Verify Channels",
            "callback_data" => "verify_first_five"
        ]
    ];

    $keyboard = [
        "inline_keyboard" => $inline
    ];

    sendMessage($chatId, $text, $keyboard);
}

// ---------- WITHDRAW: CHANNEL 6–10 MESSAGE ----------
function sendJoinChannelsMessageWithdraw($chatId)
{
    global $channels;

    $text  = "🏧 <b>Withdrawal Unlock</b>\n\n";
    $text .= "UPI withdrawal complete karne ke liye ab ye <b>6 se 10</b> channel JOIN karo.\n";
    $text .= "Niche diye gaye <b>Join</b> buttons se join karo,\n";
    $text .= "phir apni <b>UPI ID</b> dobara bhejo.\n";

    // 6–10 channels, 2-column layout
    $inline = [];
    $row = [];
    for ($i = 5; $i < 10; $i++) {
        $ch = $channels[$i];
        $row[] = [
            "text" => "Join",
            "url"  => $ch['link']
        ];
        if (count($row) == 2) {
            $inline[] = $row;
            $row = [];
        }
    }
    if (!empty($row)) {
        $inline[] = $row;
    }

    $keyboard = [
        "inline_keyboard" => $inline
    ];

    sendMessage($chatId, $text, $keyboard);
}

// ---------- ADVANCED TRANSACTION HISTORY ----------
function getUserTransactionsText($telegram_id, $limit = 10)
{
    global $mysqli;

    $telegram_id = (string)$telegram_id;
    $safe_tid = $mysqli->real_escape_string($telegram_id);

    $q = $mysqli->query("SELECT * FROM users WHERE telegram_id = '$safe_tid' LIMIT 1");
    if (!$q || $q->num_rows == 0) {
        return "Koi transaction record nahi mila.";
    }
    $u   = $q->fetch_assoc();
    $uid = intval($u['id']);
    $currentBalance = number_format($u['balance'], 2);

    $limit = intval($limit);
    $tq = $mysqli->query("SELECT type, amount, details, created_at 
                          FROM transactions 
                          WHERE user_id = $uid 
                          ORDER BY id DESC 
                          LIMIT $limit");

    if (!$tq || $tq->num_rows == 0) {
        return "📜 <b>Transaction History</b>\n\nAbhi tak koi transaction nahi hua.\n\nCurrent Balance: <b>₹$currentBalance</b>";
    }

    $lines = [];
    $i = 1;
    while ($row = $tq->fetch_assoc()) {
        $type   = $row['type'];
        $amount = number_format($row['amount'], 2);
        $dtRaw  = $row['created_at'];
        $dt     = date('d-m-Y H:i', strtotime($dtRaw));
        $det    = $row['details'];

        switch ($type) {
            case 'bonus':
                $label = "🎁 Bonus";
                $sign  = "➕";
                break;
            case 'referral':
                $label = "👥 Referral";
                $sign  = "➕";
                break;
            case 'withdraw':
                $label = "🏧 Withdraw";
                $sign  = "➖";
                break;
            case 'deposit_91club':
                $label = "🎮 91Club Deposit";
                $sign  = "➖";
                break;
            case 'deposit_okwin':
                $label = "🎮 OKWin Deposit";
                $sign  = "➖";
                break;
            default:
                $label = "Txn";
                $sign  = "";
                break;
        }

        $line  = $i . ". " . $label . "  (" . $dt . ")\n";
        $line .= "   " . $sign . "₹" . $amount;
        if (!empty($det)) {
            $line .= "\n   ➤ " . $det;
        }

        $lines[] = $line;
        $i++;
    }

    $header  = "📜 <b>Transaction History</b>\n";
    $header .= "Showing last " . count($lines) . " records.\n";
    $header .= "Current Balance: <b>₹$currentBalance</b>\n\n";

    return $header . implode("\n\n", $lines);
}

// ---------- UPDATE HANDLING ----------
$update = json_decode(file_get_contents("php://input"), true);

if (!$update) {
    exit("No update");
}

// ========== MESSAGE ==========
if (isset($update['message'])) {

    $message = $update['message'];
    $chatId  = $message['chat']['id'];
    $userId  = $message['from']['id'];
    $firstName = isset($message['from']['first_name']) ? $message['from']['first_name'] : "";
    $username  = isset($message['from']['username']) ? $message['from']['username'] : "";
    $text   = isset($message['text']) ? trim($message['text']) : "";

    // Referral parameter handle
    $referral_from = null;
    if (strpos($text, "/start") === 0) {
        $parts = explode(" ", $text);
        if (count($parts) > 1) {
            $referral_from = $parts[1]; // referrer ka telegram_id
        }
    }

    $user = getOrCreateUser($userId, $firstName, $username, $referral_from);

    // ---- If /start ----
    if (strpos($text, "/start") === 0) {
        sendJoinChannelsMessageStart($chatId);   // 1–5 channel message
        return;
    }

    // Now handle steps / menu
    $currentStep = $user['step'];

    // MAIN BUTTONS LIST (step cancel ke liye)
    $mainButtons = [
        "💰 Balance",
        "👥 Referral",
        "🏧 UPI Withdrawal",
        "🎮 91 Club Deposit",
        "🎮 OK Win Deposit"
    ];

    // agar UPI steps active hain aur user koi main button dabaye to cancel
    if (in_array($currentStep, ['awaiting_upi_step1','awaiting_upi_step2'], true)
        && in_array($text, $mainButtons, true)) {
        setUserStep($userId, null, null);
        $currentStep = null;
        $user['step'] = null;
    }

    // ========== STEP: UPI WITHDRAW - STEP 1 ==========
    // user ne pehli baar UPI bheja -> channels 6–10 join message
    if ($currentStep === 'awaiting_upi_step1') {

        // yahan UPI ko validate nahi kar rahe, sirf channels 6–10 ka message
        sendJoinChannelsMessageWithdraw($chatId);
        sendMessage($chatId, "⚠️ Pehle channel <b>6 se 10</b> join karo.\nJoin karne ke baad apni <b>UPI ID</b> dobara bhejna.");
        setUserStep($userId, 'awaiting_upi_step2', null);
        exit;
    }

    // ========== STEP: UPI WITHDRAW - STEP 2 ==========
    if ($currentStep === 'awaiting_upi_step2') {
        global $min_withdraw;

        $upi = $text;

        if (!isValidUpi($upi)) {
            sendMessage($chatId, "❌ <b>UPI ID galat format me hai.</b>\nExample: <code>user@upi</code>\n\nSahi UPI ID dubara bhejo.");
            exit;
        }

        // ab 6–10 channels verify
        if (!verifyLastFiveChannels($userId)) {
            sendMessage($chatId, "❌ <b>Abhi tak sabhi channel 6 se 10 join nahi hue.</b>\nPlease pehle join karo, phir UPI ID dobara bhejna.");
            sendJoinChannelsMessageWithdraw($chatId);
            exit;
        }

        $balance = floatval($user['balance']);

        if ($balance < $min_withdraw) {
            sendMessage($chatId, "❌ <b>Insufficient Balance</b>\nMinimum withdrawal ₹" . $min_withdraw . "\nAapka balance: ₹" . $balance);
            setUserStep($userId, null, null);
        } else {
            // full balance withdraw
            $amount = $balance;

            // Insert withdraw request
            global $mysqli;
            $uid = intval($user['id']);
            $safe_upi = $mysqli->real_escape_string($upi);
            $mysqli->query("INSERT INTO withdraw_requests (user_id, amount, upi_id) 
                            VALUES ($uid, $amount, '$safe_upi')");

            // Balance zero
            updateUserBalance($userId, -$amount);
            addTransaction($userId, 'withdraw', $amount, "UPI: $upi");
            setUserStep($userId, null, null);

            sendMessage($chatId, "✅ <b>Withdrawal Request Submitted</b>\nAmount: ₹$amount\nUPI: <code>$upi</code>\n\nAdmin approval ke baad aapko payment mil jayega.");
        }
        exit;
    }

    // ========== STEP: 91 CLUB UID / AMOUNT ==========
    if ($currentStep === 'awaiting_91_uid') {
        $temp = [
            "type" => "91club",
            "uid"  => $text
        ];
        setUserStep($userId, 'awaiting_91_amount', json_encode($temp));

        sendMessage($chatId, "🎮 <b>91 Club Deposit</b>\nAmount bhejo (minimum ₹100, maximum ₹" . $user['balance'] . ")");
        exit;
    }

    if ($currentStep === 'awaiting_91_amount') {
        global $min_deposit_game;
        $amount = floatval($text);
        $balance = floatval($user['balance']);

        $temp = json_decode($user['temp_data'], true);
        $uid = isset($temp['uid']) ? $temp['uid'] : 'N/A';

        if ($amount < $min_deposit_game) {
            sendMessage($chatId, "❌ Minimum 91 Club deposit ₹$min_deposit_game hai.\nDobara amount bhejo.");
            exit;
        }
        if ($amount > $balance) {
            sendMessage($chatId, "❌ Insufficient balance.\nAapka balance: ₹$balance\nDobara amount bhejo (≤ balance).");
            exit;
        }

        // Deduct balance
        updateUserBalance($userId, -$amount);
        addTransaction($userId, 'deposit_91club', $amount, "91 Club UID: $uid");
        setUserStep($userId, null, null);

        sendMessage($chatId, "✅ <b>91 Club Deposit Request</b>\nUID: <code>$uid</code>\nAmount: ₹$amount\n\nAdmin aapka deposit process karega.");
        exit;
    }

    // ========== STEP: OK WIN UID / AMOUNT ==========
    if ($currentStep === 'awaiting_okwin_uid') {
        $temp = [
            "type" => "okwin",
            "uid"  => $text
        ];
        setUserStep($userId, 'awaiting_okwin_amount', json_encode($temp));

        sendMessage($chatId, "🎯 <b>OK Win Deposit</b>\nAmount bhejo (minimum ₹100, maximum ₹" . $user['balance'] . ")");
        exit;
    }

    if ($currentStep === 'awaiting_okwin_amount') {
        global $min_deposit_game;
        $amount = floatval($text);
        $balance = floatval($user['balance']);

        $temp = json_decode($user['temp_data'], true);
        $uid = isset($temp['uid']) ? $temp['uid'] : 'N/A';

        if ($amount < $min_deposit_game) {
            sendMessage($chatId, "❌ Minimum OK Win deposit ₹$min_deposit_game hai.\nDobara amount bhejo.");
            exit;
        }
        if ($amount > $balance) {
            sendMessage($chatId, "❌ Insufficient balance.\nAapka balance: ₹$balance\nDobara amount bhejo (≤ balance).");
            exit;
        }

        // Deduct balance
        updateUserBalance($userId, -$amount);
        addTransaction($userId, 'deposit_okwin', $amount, "OK Win UID: $uid");
        setUserStep($userId, null, null);

        sendMessage($chatId, "✅ <b>OK Win Deposit Request</b>\nUID: <code>$uid</code>\nAmount: ₹$amount\n\nAdmin aapka deposit process karega.");
        exit;
    }

    // -------- MAIN BUTTONS HANDLING --------

    if ($text === "💰 Balance") {
        $bal = number_format($user['balance'], 2);
        $msg  = "💰 <b>Your Balance</b>\n\n";
        $msg .= "Current balance: <b>₹$bal</b>";

        $inline = [
            "inline_keyboard" => [
                [
                    [
                        "text" => "📜 Transaction History",
                        "callback_data" => "tx_history"
                    ]
                ]
            ]
        ];

        sendMessage($chatId, $msg, $inline);
        exit;
    }

    if ($text === "👥 Referral") {
        global $botUserName, $referral_bonus;

        $ref_link = "https://t.me/" . $botUserName . "?start=" . $userId;
        $msg  = "👥 <b>Referral System</b>\n\n";
        $msg .= "Per referral: <b>₹$referral_bonus</b> milega.\n";
        $msg .= "Aapka referral link:\n<code>$ref_link</code>";
        sendMessage($chatId, $msg);
        exit;
    }

    if ($text === "🏧 UPI Withdrawal") {
        global $min_withdraw;

        // 1) Pehle balance check
        $bal = floatval($user['balance']);
        if ($bal < $min_withdraw) {
            sendMessage($chatId, "❌ <b>Insufficient Balance</b>\nMinimum withdrawal ₹$min_withdraw hai.\nAapka balance: ₹$bal");
            exit;
        }

        // 2) Ab referrals check
        $refCount = getReferralCount($userId);
        if ($refCount < 10) {
            $need = 10 - $refCount;
            $msg  = "❌ <b>Withdrawal Locked</b>\n\n";
            $msg .= "Minimum <b>10 referrals</b> chahiye withdraw ke liye.\n";
            $msg .= "Aapke referrals: <b>$refCount / 10</b>\n\n";
            $msg .= "Aur <b>$need</b> referral complete karo, phir withdraw kar sakte ho.";
            sendMessage($chatId, $msg);
            exit;
        }

        // 3) Sab ok → UPI step start
        setUserStep($userId, 'awaiting_upi_step1', null); // STEP 1
        sendMessage($chatId, "🏧 <b>UPI Withdrawal</b>\n\nAapka balance: ₹$bal\n\nApna <b>UPI ID</b> bhejo (jaise: <code>user@upi</code>)");
        exit;
    }

    // 91 CLUB BUTTON
    if (strpos($text, "91 Club Deposit") !== false) {
        global $min_deposit_game;
        $bal = floatval($user['balance']);
        if ($bal < $min_deposit_game) {
            sendMessage($chatId, "❌ 91 Club deposit ke liye minimum ₹$min_deposit_game chahiye.\nAapka balance: ₹$bal");
        } else {
            setUserStep($userId, 'awaiting_91_uid', null);
            sendMessage($chatId, "🎮 <b>91 Club Deposit</b>\n\nPehle apna <b>91 Club UID</b> bhejo.");
        }
        exit;
    }

    // OK WIN BUTTON
    if (strpos($text, "OK Win Deposit") !== false) {
        global $min_deposit_game;
        $bal = floatval($user['balance']);
        if ($bal < $min_deposit_game) {
            sendMessage($chatId, "❌ OK Win deposit ke liye minimum ₹$min_deposit_game chahiye.\nAapka balance: ₹$bal");
        } else {
            setUserStep($userId, 'awaiting_okwin_uid', null);
            sendMessage($chatId, "🎯 <b>OK Win Deposit</b>\n\nPehle apna <b>OK Win UID</b> bhejo.");
        }
        exit;
    }

    // Default reply
    sendMessage($chatId, "🙏 Pehle /start karke channel 1 se 5 join + verify karo.\nPhir main menu buttons use karo.");
    sendMainMenu($chatId, $user);
    exit;
}

// ========== CALLBACK QUERY ==========
elseif (isset($update['callback_query'])) {

    $callback   = $update['callback_query'];
    $data       = $callback['data'];
    $chatId     = $callback['message']['chat']['id'];
    $userId     = $callback['from']['id'];
    $callbackId = $callback['id'];

    $user = getUserByTelegram($userId);

    if ($data === "verify_first_five") {
        answerCallback($callbackId, "⏳ Checking membership...");

        $ok = verifyFirstFiveChannels($userId);

        if ($ok) {
            // Show bonus deposit button
            $text  = "✅ <b>Channel 1–5 Verification Successful!</b>\n\n";
            $text .= "Ab aap bot ka main menu use kar sakte ho.\nNiche ka <b>💵 Get ₹10 Bonus</b> button dabao (sirf ek baar).";

            $keyboard = [
                "inline_keyboard" => [
                    [
                        ["text" => "💵 Get ₹10 Bonus", "callback_data" => "get_join_bonus"]
                    ]
                ]
            ];

            sendMessage($chatId, $text, $keyboard);
            sendMainMenu($chatId, $user);
        } else {
            $text  = "❌ <b>Verification Failed</b>\n\n";
            $text .= "Lagta hai aap ne channel 1 se 5 me se sabhi join nahi kiye.\n\n";
            $text .= "Pehle sab 5 channel join karo, fir <b>✅ Verify Channels</b> dubara dabao.";

            sendJoinChannelsMessageStart($chatId);
            sendMessage($chatId, $text);
        }
        exit;
    }

    if ($data === "get_join_bonus") {
        global $join_bonus;

        if ($user['join_bonus_claimed']) {
            answerCallback($callbackId, "❗ Aap pehle hi bonus le chuke ho.");
            sendMessage($chatId, "ℹ️ Aap pehle hi ₹$join_bonus join bonus le chuke ho.");
        } else {
            updateUserBalance($userId, $join_bonus);

            global $mysqli;
            $tid = $mysqli->real_escape_string((string)$userId);
            $mysqli->query("UPDATE users SET join_bonus_claimed = 1 WHERE telegram_id = '$tid'");

            addTransaction($userId, 'bonus', $join_bonus, "Join bonus");

            answerCallback($callbackId, "✅ ₹$join_bonus bonus credited!");
            sendMessage($chatId, "🎉 <b>Bonus Credited</b>\n\nAapke account me ₹$join_bonus add ho gya hai.");
            $user = getUserByTelegram($userId);
            sendMainMenu($chatId, $user);
        }
        exit;
    }

    if ($data === "tx_history") {
        $txt = getUserTransactionsText($userId, 10);
        answerCallback($callbackId, "");
        sendMessage($chatId, $txt);
        exit;
    }

    answerCallback($callbackId, "");
    exit;
}

?>
