<?php
session_start();
if(!isset($_SESSION['admin_logged_in'])){ header('Location: login.php'); exit; }

require_once 'db.php';
require_once 'config.php';
include 'header.php';

$pdo = getDB();
$msg = '';

// Send broadcast
if(isset($_POST['send'])){
    $message = trim($_POST['message']);
    $image   = trim($_POST['image']); // optional image URL
    if($message){
        // Fetch users in batches to avoid timeouts
        $users = $pdo->query('SELECT telegram_id FROM users')->fetchAll();
        $sent = 0;
        foreach($users as $u){
            if($image){
                // send photo with caption
                $url = "https://api.telegram.org/bot".BOT_TOKEN."/sendPhoto";
                $data = [
                    'chat_id'=>$u['telegram_id'],
                    'photo'=>$image,
                    'caption'=>$message,
                    'parse_mode'=>'HTML'
                ];
                @file_get_contents($url.'?'.http_build_query($data));
            } else {
                $url = "https://api.telegram.org/bot".BOT_TOKEN."/sendMessage";
                @file_get_contents($url.'?'.http_build_query(['chat_id'=>$u['telegram_id'],'text'=>$message,'parse_mode'=>'HTML']));
            }
            $sent++;
            // small delay could be added: usleep(20000);
        }
        $msg = "Broadcast sent to {$sent} users.";
    } else {
        $msg = "Please enter a message.";
    }
}

?>

<div class="container mx-auto p-4">
  <h1 class="text-2xl font-bold mb-4">Broadcast</h1>

  <?php if($msg): ?><div class="mb-4 p-3 rounded bg-green-100 text-green-800"><?=htmlspecialchars($msg)?></div><?php endif; ?>

  <form method="POST" class="bg-white p-4 rounded shadow grid gap-3">
    <label class="font-medium">Message (HTML allowed)</label>
    <textarea name="message" rows="6" class="border p-2 rounded w-full" placeholder="Write message to send to all users..."></textarea>

    <label class="font-medium">Image URL (optional)</label>
    <input name="image" class="border p-2 rounded w-full" placeholder="https://... (optional)">

    <div>
      <button name="send" class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded">Send Broadcast</button>
    </div>
  </form>
</div>

<?php include 'footer.php'; ?>
