<?php
require_once __DIR__.'/db.php';
require_once __DIR__.'/config.php';

$settings_file = __DIR__.'/admin/settings.json';
$settings = ['reward_join'=>45,'reward_referral'=>15,'min_withdraw'=>150];
if(file_exists($settings_file)){
    $tmp = json_decode(file_get_contents($settings_file), true);
    if(is_array($tmp)) $settings = array_merge($settings, $tmp);
}
define('REWARD_PER_JOIN', $settings['reward_join']);
define('REWARD_PER_REFERRAL', $settings['reward_referral']);
define('MIN_WITHDRAWAL', $settings['min_withdraw']);

$input = json_decode(file_get_contents('php://input'), true);
if(!$input) exit;

$pdo = getDB();

/**
 * Emoji / 4-byte unicode remove + length limit
 * ताकि MySQL में Incorrect string value वाला error न आए
 */
function sanitizeText($text){
    if ($text === null) return '';
    // remove 4-byte emoji etc.
    $text = preg_replace('/[\xF0-\xF7][\x80-\xBF]{3}/', '', $text);
    // safety length
    return substr($text, 0, 64);
}

function apiRequest($method, $params = []) {
    $url = 'https://api.telegram.org/bot'.BOT_TOKEN.'/'.$method;
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_POSTFIELDS => $params
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

function sendMessage($chat_id, $text, $reply_markup = null) {
    $data = ['chat_id'=>$chat_id,'text'=>$text,'parse_mode'=>'HTML'];
    if($reply_markup) $data['reply_markup'] = json_encode($reply_markup);
    apiRequest('sendMessage', $data);
}

function editMessage($chat_id, $message_id, $text, $reply_markup = null) {
    $data = ['chat_id'=>$chat_id,'message_id'=>$message_id,'text'=>$text,'parse_mode'=>'HTML'];
    if($reply_markup) $data['reply_markup'] = json_encode($reply_markup);
    apiRequest('editMessageText', $data);
}

function answerCallback($callback_id, $text = '', $show_alert = false) {
    apiRequest('answerCallbackQuery', [
        'callback_query_id'=>$callback_id,
        'text'=>$text,
        'show_alert'=>$show_alert
    ]);
}

function ensureUser($user){
    global $pdo;
    try {
        $stmt = $pdo->prepare('SELECT * FROM users WHERE telegram_id=?');
        $stmt->execute([$user['id']]);
        if(!$stmt->fetch()){
            $ref = isset($user['start_param']) ? (int)$user['start_param'] : null;

            // sanitize username + first_name to avoid emoji errors
            $username   = sanitizeText($user['username']   ?? '');
            $first_name = sanitizeText($user['first_name'] ?? '');

            $pdo->prepare('INSERT INTO users (telegram_id, username, first_name, balance, created_at, referrer) VALUES (?,?,?,?,NOW(),?)')
                ->execute([$user['id'], $username, $first_name, 0, $ref]);

            if($ref){
                $r = $pdo->prepare('SELECT * FROM users WHERE id=?');
                $r->execute([$ref]);
                $refrow = $r->fetch();
                if($refrow){
                    $pdo->prepare('UPDATE users SET balance = balance + ? WHERE id=?')
                        ->execute([REWARD_PER_REFERRAL, $refrow['id']]);
                }
            }
        }
    } catch (Exception $e) {
        // Agar DB me koi problem ho bhi, bot crash na ho
        error_log('ensureUser error: '.$e->getMessage());
    }
}

$channels = $pdo->query('SELECT * FROM channels ORDER BY id ASC')->fetchAll(PDO::FETCH_ASSOC);

if(isset($input['message'])){
    $msg = $input['message'];
    $chat_id = $msg['chat']['id'];
    $text = trim($msg['text'] ?? '');
    $uid = $msg['from']['id'];

    if(preg_match('/^\/start(\s+(\d+))?/i',$text,$m)){
        $start_param = $m[2] ?? null;
        $user = [
            'id'=>$uid,
            'username'=>$msg['from']['username'] ?? '',
            'first_name'=>$msg['from']['first_name'] ?? '',
            'start_param'=>$start_param
        ];
        ensureUser($user);
        $keyboard = [
            'keyboard'=>[
                ['📢 Join Channels','🔗 My Referrals'],
                ['💰 Balance','💸 Withdraw'],
                ['💸 Withdraw Status','ℹ️ Help']
            ],
            'resize_keyboard'=>true
        ];
        $fname = $user['first_name'] ?: 'User';
        sendMessage($chat_id, "👋 Hello {$fname}!\nWelcome to Money King Bot.\nEarn by joining channels and referring friends.", $keyboard);
        exit;
    }

    if($text === '📢 Join Channels'){
        $message = "📢 <b>Join the channels below:</b>\nAfter joining click <b>Joined & Verify ✅</b>.";
        $buttons = [];
        foreach($channels as $c){
            $buttons[] = [['text'=>'Join: '.$c['title'], 'url'=>$c['link']]];
        }
        $buttons[] = [['text'=>'Joined & Verify ✅','callback_data'=>'verify_join']];
        $inline = ['inline_keyboard'=>$buttons];
        sendMessage($chat_id, $message, $inline);
        exit;
    }

    if($text === '💰 Balance'){
        $st = $pdo->prepare('SELECT balance FROM users WHERE telegram_id=?');
        $st->execute([$uid]);
        $bal = $st->fetch()['balance'] ?? 0;
        sendMessage($chat_id, "💼 Your balance: ₹".$bal);
        exit;
    }

    if($text === '🔗 My Referrals'){
        $st = $pdo->prepare('SELECT * FROM users WHERE telegram_id=?');
        $st->execute([$uid]);
        $u = $st->fetch();
        $rid = $u['id'];
        $r = $pdo->prepare('SELECT COUNT(*) as c FROM users WHERE referrer=?');
        $r->execute([$rid]);
        $count = $r->fetch()['c'];
        $ref_link = "https://t.me/".trim(BOT_USERNAME,'@')."?start=".$rid;
        sendMessage($chat_id, "You have {$count} referrals.\nReferral link:\n{$ref_link}");
        exit;
    }

    if($text === '💸 Withdraw'){
        $inline = ['inline_keyboard'=>[
            [['text'=>'₹200','callback_data'=>'withdraw_200'], ['text'=>'₹250','callback_data'=>'withdraw_250']],
            [['text'=>'₹350','callback_data'=>'withdraw_350'], ['text'=>'₹500','callback_data'=>'withdraw_500']]
        ]];
        sendMessage($chat_id, "💸 Please choose an amount to withdraw:", $inline);
        exit;
    }

    // When user sends UPI after clicking amount
    $tmp = $pdo->prepare('SELECT * FROM temp_withdraw WHERE user_telegram=?');
    $tmp->execute([$uid]);
    $pending = $tmp->fetch(PDO::FETCH_ASSOC);
    if($pending){
        $upi = trim($text);
        $amount = (int)$pending['amount'];
        $u = $pdo->prepare('SELECT balance FROM users WHERE telegram_id=?');
        $u->execute([$uid]);
        $user = $u->fetch();
        $balance = $user['balance'] ?? 0;

        if($balance < $amount){
            sendMessage($chat_id, "❌ Insufficient balance for ₹{$amount}. Your balance: ₹{$balance}");
            $pdo->prepare('DELETE FROM temp_withdraw WHERE user_telegram=?')->execute([$uid]);
            exit;
        }

        $pdo->prepare('INSERT INTO withdrawals (user_telegram, amount, upi, status, created_at) VALUES (?,?,?,?,NOW())')
            ->execute([$uid, $amount, $upi, 'processing']);
        $pdo->prepare('DELETE FROM temp_withdraw WHERE user_telegram=?')->execute([$uid]);
        sendMessage($chat_id, "✅ Withdrawal request of ₹{$amount} submitted.\n💳 UPI: {$upi}\nStatus: Processing.");
        exit;
    }
}

if(isset($input['callback_query'])){
    $cb = $input['callback_query'];
    $chat_id = $cb['message']['chat']['id'];
    $uid = $cb['from']['id'];
    $data = $cb['data'];
    $cb_id = $cb['id'];
    $msg_id = $cb['message']['message_id'];

    answerCallback($cb_id);

    if($data === 'verify_join'){
        editMessage($chat_id, $msg_id, "⏳ Verifying your joins, please wait...");
        $rewarded = 0;
        foreach($channels as $c){
            $s = $pdo->prepare('SELECT * FROM user_joins WHERE user_telegram=? AND channel_id=?');
            $s->execute([$uid,$c['id']]);
            if(!$s->fetch()){
                $pdo->prepare('INSERT INTO user_joins (user_telegram, channel_id, joined_at) VALUES (?,?,NOW())')
                    ->execute([$uid,$c['id']]);
                $pdo->prepare('UPDATE users SET balance = balance + ? WHERE telegram_id=?')
                    ->execute([REWARD_PER_JOIN, $uid]);
                $rewarded += REWARD_PER_JOIN;
            }
        }
        if($rewarded>0){
            $b = $pdo->prepare('SELECT balance FROM users WHERE telegram_id=?');
            $b->execute([$uid]);
            $bal = $b->fetch()['balance'] ?? 0;
            editMessage($chat_id, $msg_id, "✅ Verified! You got ₹{$rewarded}\n💼 Balance: ₹{$bal}");
        } else {
            editMessage($chat_id, $msg_id, "⚠️ You already verified all channels.");
        }
        exit;
    }

    if(preg_match('/^withdraw_(\d+)$/', $data, $m)){
        $amount = (int)$m[1];
        $pdo->prepare('DELETE FROM temp_withdraw WHERE user_telegram=?')->execute([$uid]);
        $pdo->prepare('INSERT INTO temp_withdraw (user_telegram, amount) VALUES (?,?)')
            ->execute([$uid,$amount]);
        answerCallback($cb_id, "Now send your UPI ID.", false);
        sendMessage($chat_id, "💳 Please send your UPI ID now to receive ₹{$amount}.");
        exit;
    }
}
?>
